<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentConfigResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse();
        if (\array_key_exists('forceSelectCaregiver', $data) && \is_int($data['forceSelectCaregiver'])) {
            $data['forceSelectCaregiver'] = (bool) $data['forceSelectCaregiver'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('shortAppointmentDescription', $data) && $data['shortAppointmentDescription'] !== null) {
            $object->setShortAppointmentDescription($data['shortAppointmentDescription']);
            unset($data['shortAppointmentDescription']);
        }
        elseif (\array_key_exists('shortAppointmentDescription', $data) && $data['shortAppointmentDescription'] === null) {
            $object->setShortAppointmentDescription(null);
        }
        if (\array_key_exists('forceSelectCaregiver', $data) && $data['forceSelectCaregiver'] !== null) {
            $object->setForceSelectCaregiver($data['forceSelectCaregiver']);
            unset($data['forceSelectCaregiver']);
        }
        elseif (\array_key_exists('forceSelectCaregiver', $data) && $data['forceSelectCaregiver'] === null) {
            $object->setForceSelectCaregiver(null);
        }
        if (\array_key_exists('minimalDelayTakeAppointment', $data)) {
            $object->setMinimalDelayTakeAppointment($data['minimalDelayTakeAppointment']);
            unset($data['minimalDelayTakeAppointment']);
        }
        if (\array_key_exists('minimalDelayCancelAppointment', $data) && $data['minimalDelayCancelAppointment'] !== null) {
            $object->setMinimalDelayCancelAppointment($data['minimalDelayCancelAppointment']);
            unset($data['minimalDelayCancelAppointment']);
        }
        elseif (\array_key_exists('minimalDelayCancelAppointment', $data) && $data['minimalDelayCancelAppointment'] === null) {
            $object->setMinimalDelayCancelAppointment(null);
        }
        if (\array_key_exists('emailAppointmentConfirmation', $data) && $data['emailAppointmentConfirmation'] !== null) {
            $object->setEmailAppointmentConfirmation($data['emailAppointmentConfirmation']);
            unset($data['emailAppointmentConfirmation']);
        }
        elseif (\array_key_exists('emailAppointmentConfirmation', $data) && $data['emailAppointmentConfirmation'] === null) {
            $object->setEmailAppointmentConfirmation(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        $dataArray['name'] = $data->getName();
        if ($data->isInitialized('shortAppointmentDescription') && null !== $data->getShortAppointmentDescription()) {
            $dataArray['shortAppointmentDescription'] = $data->getShortAppointmentDescription();
        }
        $dataArray['forceSelectCaregiver'] = $data->getForceSelectCaregiver();
        if ($data->isInitialized('minimalDelayTakeAppointment') && null !== $data->getMinimalDelayTakeAppointment()) {
            $dataArray['minimalDelayTakeAppointment'] = $data->getMinimalDelayTakeAppointment();
        }
        if ($data->isInitialized('minimalDelayCancelAppointment') && null !== $data->getMinimalDelayCancelAppointment()) {
            $dataArray['minimalDelayCancelAppointment'] = $data->getMinimalDelayCancelAppointment();
        }
        if ($data->isInitialized('emailAppointmentConfirmation') && null !== $data->getEmailAppointmentConfirmation()) {
            $dataArray['emailAppointmentConfirmation'] = $data->getEmailAppointmentConfirmation();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse::class => false];
    }
}