<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentConfigRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest();
        if (\array_key_exists('forceSelectCaregiver', $data) && \is_int($data['forceSelectCaregiver'])) {
            $data['forceSelectCaregiver'] = (bool) $data['forceSelectCaregiver'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('shortAppointmentDescription', $data)) {
            $object->setShortAppointmentDescription($data['shortAppointmentDescription']);
            unset($data['shortAppointmentDescription']);
        }
        if (\array_key_exists('forceSelectCaregiver', $data)) {
            $object->setForceSelectCaregiver($data['forceSelectCaregiver']);
            unset($data['forceSelectCaregiver']);
        }
        if (\array_key_exists('minimalDelayTakeAppointment', $data)) {
            $object->setMinimalDelayTakeAppointment($data['minimalDelayTakeAppointment']);
            unset($data['minimalDelayTakeAppointment']);
        }
        if (\array_key_exists('minimalDelayCancelAppointment', $data)) {
            $object->setMinimalDelayCancelAppointment($data['minimalDelayCancelAppointment']);
            unset($data['minimalDelayCancelAppointment']);
        }
        if (\array_key_exists('emailAppointmentConfirmation', $data)) {
            $object->setEmailAppointmentConfirmation($data['emailAppointmentConfirmation']);
            unset($data['emailAppointmentConfirmation']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('shortAppointmentDescription') && null !== $data->getShortAppointmentDescription()) {
            $dataArray['shortAppointmentDescription'] = $data->getShortAppointmentDescription();
        }
        if ($data->isInitialized('forceSelectCaregiver') && null !== $data->getForceSelectCaregiver()) {
            $dataArray['forceSelectCaregiver'] = $data->getForceSelectCaregiver();
        }
        if ($data->isInitialized('minimalDelayTakeAppointment') && null !== $data->getMinimalDelayTakeAppointment()) {
            $dataArray['minimalDelayTakeAppointment'] = $data->getMinimalDelayTakeAppointment();
        }
        if ($data->isInitialized('minimalDelayCancelAppointment') && null !== $data->getMinimalDelayCancelAppointment()) {
            $dataArray['minimalDelayCancelAppointment'] = $data->getMinimalDelayCancelAppointment();
        }
        if ($data->isInitialized('emailAppointmentConfirmation') && null !== $data->getEmailAppointmentConfirmation()) {
            $dataArray['emailAppointmentConfirmation'] = $data->getEmailAppointmentConfirmation();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest::class => false];
    }
}