<?php

namespace NoahVet\PlanningVeto\Model;

class ReasonResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Identifier of the reason (UUID)
     *
     * @var string
     */
    protected $id;
    /**
     * 
     *
     * @var ReasonResponseVeterinaryEstablishmentConfig
     */
    protected $veterinaryEstablishmentConfig;
    /**
     * Identifier of the veterinary establishment rason provided by the business software like VetoPartner (External UUID)
     *
     * @var string
     */
    protected $veterinaryEstablishmentReasonId;
    /**
     * Name of the reason
     *
     * @var string
     */
    protected $name;
    /**
     * Duration of the reason in minutes
     *
     * @var int
     */
    protected $duration;
    /**
     * Date of creation of the reason
     *
     * @var \DateTime
     */
    protected $created;
    /**
     * Date of last update of the reason
     *
     * @var \DateTime
     */
    protected $updated;
    /**
     * Identifier of the reason (UUID)
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * Identifier of the reason (UUID)
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * 
     *
     * @return ReasonResponseVeterinaryEstablishmentConfig
     */
    public function getVeterinaryEstablishmentConfig() : ReasonResponseVeterinaryEstablishmentConfig
    {
        return $this->veterinaryEstablishmentConfig;
    }
    /**
     * 
     *
     * @param ReasonResponseVeterinaryEstablishmentConfig $veterinaryEstablishmentConfig
     *
     * @return self
     */
    public function setVeterinaryEstablishmentConfig(ReasonResponseVeterinaryEstablishmentConfig $veterinaryEstablishmentConfig) : self
    {
        $this->initialized['veterinaryEstablishmentConfig'] = true;
        $this->veterinaryEstablishmentConfig = $veterinaryEstablishmentConfig;
        return $this;
    }
    /**
     * Identifier of the veterinary establishment rason provided by the business software like VetoPartner (External UUID)
     *
     * @return string
     */
    public function getVeterinaryEstablishmentReasonId() : string
    {
        return $this->veterinaryEstablishmentReasonId;
    }
    /**
     * Identifier of the veterinary establishment rason provided by the business software like VetoPartner (External UUID)
     *
     * @param string $veterinaryEstablishmentReasonId
     *
     * @return self
     */
    public function setVeterinaryEstablishmentReasonId(string $veterinaryEstablishmentReasonId) : self
    {
        $this->initialized['veterinaryEstablishmentReasonId'] = true;
        $this->veterinaryEstablishmentReasonId = $veterinaryEstablishmentReasonId;
        return $this;
    }
    /**
     * Name of the reason
     *
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * Name of the reason
     *
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * Duration of the reason in minutes
     *
     * @return int
     */
    public function getDuration() : int
    {
        return $this->duration;
    }
    /**
     * Duration of the reason in minutes
     *
     * @param int $duration
     *
     * @return self
     */
    public function setDuration(int $duration) : self
    {
        $this->initialized['duration'] = true;
        $this->duration = $duration;
        return $this;
    }
    /**
     * Date of creation of the reason
     *
     * @return \DateTime
     */
    public function getCreated() : \DateTime
    {
        return $this->created;
    }
    /**
     * Date of creation of the reason
     *
     * @param \DateTime $created
     *
     * @return self
     */
    public function setCreated(\DateTime $created) : self
    {
        $this->initialized['created'] = true;
        $this->created = $created;
        return $this;
    }
    /**
     * Date of last update of the reason
     *
     * @return \DateTime
     */
    public function getUpdated() : \DateTime
    {
        return $this->updated;
    }
    /**
     * Date of last update of the reason
     *
     * @param \DateTime $updated
     *
     * @return self
     */
    public function setUpdated(\DateTime $updated) : self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;
        return $this;
    }
}