<?php

namespace NoahVet\PlanningVeto\Model;

class EventRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var EventRequestCaregiverVeterinaryEstablishment
     */
    protected $caregiverVeterinaryEstablishment;
    /**
     * 
     *
     * @var EventRequestReason
     */
    protected $reason;
    /**
     * State of the event
     *
     * @var string
     */
    protected $status;
    /**
     * Color of the event to show in the schedule
     *
     * @var string
     */
    protected $color;
    /**
     * 
     *
     * @var EventRequestCustomer
     */
    protected $customer;
    /**
     * 
     *
     * @var EventRequestCaregiver
     */
    protected $caregiver;
    /**
     * 
     *
     * @var EventRequestEventType
     */
    protected $eventType;
    /**
     * Name of the pet in Cam
     *
     * @var string
     */
    protected $petName;
    /**
     * breed of the pet in Cam
     *
     * @var string
     */
    protected $breed;
    /**
     * species of the pet in Cam
     *
     * @var string
     */
    protected $species;
    /**
     * Identifier of the pet (UUID)
     *
     * @var string
     */
    protected $petId;
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @var string
     */
    protected $speciesId;
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @var string
     */
    protected $breedId;
    /**
     * Identifier of the caregiver (UUID)
     *
     * @var string
     */
    protected $principalId;
    /**
     * Date of last update of the event
     *
     * @var \DateTime
     */
    protected $startDate;
    /**
     * Date of last update of the event
     *
     * @var \DateTime
     */
    protected $endDate;
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @var bool
     */
    protected $automaticCaregiverSelection;
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @var string
     */
    protected $creatorId;
    /**
     * 
     *
     * @return EventRequestCaregiverVeterinaryEstablishment
     */
    public function getCaregiverVeterinaryEstablishment() : EventRequestCaregiverVeterinaryEstablishment
    {
        return $this->caregiverVeterinaryEstablishment;
    }
    /**
     * 
     *
     * @param EventRequestCaregiverVeterinaryEstablishment $caregiverVeterinaryEstablishment
     *
     * @return self
     */
    public function setCaregiverVeterinaryEstablishment(EventRequestCaregiverVeterinaryEstablishment $caregiverVeterinaryEstablishment) : self
    {
        $this->initialized['caregiverVeterinaryEstablishment'] = true;
        $this->caregiverVeterinaryEstablishment = $caregiverVeterinaryEstablishment;
        return $this;
    }
    /**
     * 
     *
     * @return EventRequestReason
     */
    public function getReason() : EventRequestReason
    {
        return $this->reason;
    }
    /**
     * 
     *
     * @param EventRequestReason $reason
     *
     * @return self
     */
    public function setReason(EventRequestReason $reason) : self
    {
        $this->initialized['reason'] = true;
        $this->reason = $reason;
        return $this;
    }
    /**
     * State of the event
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * State of the event
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
    /**
     * Color of the event to show in the schedule
     *
     * @return string
     */
    public function getColor() : string
    {
        return $this->color;
    }
    /**
     * Color of the event to show in the schedule
     *
     * @param string $color
     *
     * @return self
     */
    public function setColor(string $color) : self
    {
        $this->initialized['color'] = true;
        $this->color = $color;
        return $this;
    }
    /**
     * 
     *
     * @return EventRequestCustomer
     */
    public function getCustomer() : EventRequestCustomer
    {
        return $this->customer;
    }
    /**
     * 
     *
     * @param EventRequestCustomer $customer
     *
     * @return self
     */
    public function setCustomer(EventRequestCustomer $customer) : self
    {
        $this->initialized['customer'] = true;
        $this->customer = $customer;
        return $this;
    }
    /**
     * 
     *
     * @return EventRequestCaregiver
     */
    public function getCaregiver() : EventRequestCaregiver
    {
        return $this->caregiver;
    }
    /**
     * 
     *
     * @param EventRequestCaregiver $caregiver
     *
     * @return self
     */
    public function setCaregiver(EventRequestCaregiver $caregiver) : self
    {
        $this->initialized['caregiver'] = true;
        $this->caregiver = $caregiver;
        return $this;
    }
    /**
     * 
     *
     * @return EventRequestEventType
     */
    public function getEventType() : EventRequestEventType
    {
        return $this->eventType;
    }
    /**
     * 
     *
     * @param EventRequestEventType $eventType
     *
     * @return self
     */
    public function setEventType(EventRequestEventType $eventType) : self
    {
        $this->initialized['eventType'] = true;
        $this->eventType = $eventType;
        return $this;
    }
    /**
     * Name of the pet in Cam
     *
     * @return string
     */
    public function getPetName() : string
    {
        return $this->petName;
    }
    /**
     * Name of the pet in Cam
     *
     * @param string $petName
     *
     * @return self
     */
    public function setPetName(string $petName) : self
    {
        $this->initialized['petName'] = true;
        $this->petName = $petName;
        return $this;
    }
    /**
     * breed of the pet in Cam
     *
     * @return string
     */
    public function getBreed() : string
    {
        return $this->breed;
    }
    /**
     * breed of the pet in Cam
     *
     * @param string $breed
     *
     * @return self
     */
    public function setBreed(string $breed) : self
    {
        $this->initialized['breed'] = true;
        $this->breed = $breed;
        return $this;
    }
    /**
     * species of the pet in Cam
     *
     * @return string
     */
    public function getSpecies() : string
    {
        return $this->species;
    }
    /**
     * species of the pet in Cam
     *
     * @param string $species
     *
     * @return self
     */
    public function setSpecies(string $species) : self
    {
        $this->initialized['species'] = true;
        $this->species = $species;
        return $this;
    }
    /**
     * Identifier of the pet (UUID)
     *
     * @return string
     */
    public function getPetId() : string
    {
        return $this->petId;
    }
    /**
     * Identifier of the pet (UUID)
     *
     * @param string $petId
     *
     * @return self
     */
    public function setPetId(string $petId) : self
    {
        $this->initialized['petId'] = true;
        $this->petId = $petId;
        return $this;
    }
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @return string
     */
    public function getSpeciesId() : string
    {
        return $this->speciesId;
    }
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @param string $speciesId
     *
     * @return self
     */
    public function setSpeciesId(string $speciesId) : self
    {
        $this->initialized['speciesId'] = true;
        $this->speciesId = $speciesId;
        return $this;
    }
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @return string
     */
    public function getBreedId() : string
    {
        return $this->breedId;
    }
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @param string $breedId
     *
     * @return self
     */
    public function setBreedId(string $breedId) : self
    {
        $this->initialized['breedId'] = true;
        $this->breedId = $breedId;
        return $this;
    }
    /**
     * Identifier of the caregiver (UUID)
     *
     * @return string
     */
    public function getPrincipalId() : string
    {
        return $this->principalId;
    }
    /**
     * Identifier of the caregiver (UUID)
     *
     * @param string $principalId
     *
     * @return self
     */
    public function setPrincipalId(string $principalId) : self
    {
        $this->initialized['principalId'] = true;
        $this->principalId = $principalId;
        return $this;
    }
    /**
     * Date of last update of the event
     *
     * @return \DateTime
     */
    public function getStartDate() : \DateTime
    {
        return $this->startDate;
    }
    /**
     * Date of last update of the event
     *
     * @param \DateTime $startDate
     *
     * @return self
     */
    public function setStartDate(\DateTime $startDate) : self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Date of last update of the event
     *
     * @return \DateTime
     */
    public function getEndDate() : \DateTime
    {
        return $this->endDate;
    }
    /**
     * Date of last update of the event
     *
     * @param \DateTime $endDate
     *
     * @return self
     */
    public function setEndDate(\DateTime $endDate) : self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @return bool
     */
    public function getAutomaticCaregiverSelection() : bool
    {
        return $this->automaticCaregiverSelection;
    }
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @param bool $automaticCaregiverSelection
     *
     * @return self
     */
    public function setAutomaticCaregiverSelection(bool $automaticCaregiverSelection) : self
    {
        $this->initialized['automaticCaregiverSelection'] = true;
        $this->automaticCaregiverSelection = $automaticCaregiverSelection;
        return $this;
    }
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @return string
     */
    public function getCreatorId() : string
    {
        return $this->creatorId;
    }
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @param string $creatorId
     *
     * @return self
     */
    public function setCreatorId(string $creatorId) : self
    {
        $this->initialized['creatorId'] = true;
        $this->creatorId = $creatorId;
        return $this;
    }
}