<?php

namespace NoahVet\PlanningVeto\Endpoint;

class UpdateCaregiver extends \NoahVet\PlanningVeto\Runtime\Client\BaseEndpoint implements \NoahVet\PlanningVeto\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a caregiver
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\CaregiverRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\PlanningVeto\Model\CaregiverRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\PlanningVeto\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/veterinary_establishment/{id}/caregivers');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\PlanningVeto\Model\CaregiverRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\PlanningVeto\Exception\UpdateCaregiverBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateCaregiverNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (204 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateCaregiverBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateCaregiverNotFoundException($response);
        }
        throw new \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}