<?php

namespace NoahVet\PlanningVeto\Endpoint;

class UpdateOneCaregiverEvent extends \NoahVet\PlanningVeto\Runtime\Client\BaseEndpoint implements \NoahVet\PlanningVeto\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update an event in caregiver schedule
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\CaregiverEventRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\PlanningVeto\Model\CaregiverEventRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\PlanningVeto\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/caregiver_schedule/event/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\PlanningVeto\Model\CaregiverEventRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\EventResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\PlanningVeto\\Model\\EventResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventNotFoundException($response);
        }
        throw new \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}